/*
 * Decompiled with CFR 0.152.
 */
package peridot.script.r;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.apache.commons.lang3.SystemUtils;
import peridot.Log;
import peridot.Output;
import peridot.script.r.Interpreter;

public class Script {
    public Output output;
    public File scriptFile;
    public AtomicBoolean running;
    String[] commandArray;
    ProcessBuilder processBuilder;
    Process process;
    AtomicBoolean stopListeningFlag;
    private String[] userArgs;

    public Script(File scriptFile) {
        this.output = new Output();
        this.running = new AtomicBoolean(false);
        this.scriptFile = scriptFile;
        this.userArgs = new String[0];
    }

    public Script(File scriptFile, String[] args, boolean autoPrintToBash) {
        this.output = new Output(autoPrintToBash);
        this.running = new AtomicBoolean(false);
        this.scriptFile = scriptFile;
        this.userArgs = args;
    }

    public void run(Interpreter interpreter, boolean wait) throws Exception {
        this.defineCommand(interpreter);
        this.processBuilder = Script.makeProcessBuilder(this.commandArray, this.scriptFile.getParentFile());
        if (this.processBuilder == null) {
            Log.logger.severe("ProcessBuilder is null, not executing analysis.");
            throw new Interpreter.InvalidExeException();
        }
        this.process = this.processBuilder.start();
        if (this.process == null) {
            throw new NullPointerException("Fatal Error: Failed to create " + this.scriptFile.getName() + "'s process.");
        }
        this.afterStart(wait);
    }

    private void update() {
        if (this.process != null) {
            this.running.set(true);
            int lines = 0;
            InputStream iStream = this.process.getInputStream();
            InputStreamReader iStreamReader = new InputStreamReader(iStream);
            BufferedReader buffReader = new BufferedReader(iStreamReader);
            try {
                String c;
                this.stopListeningFlag = new AtomicBoolean();
                this.stopListeningFlag.set(false);
                while ((c = buffReader.readLine()) != null && !this.stopListeningFlag.get()) {
                    this.output.appendLine(c);
                    ++lines;
                }
            }
            catch (IOException ex) {
                this.output.appendLine("IOException in " + this.scriptFile.getName() + " instance. ");
                Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            this.afterEnd();
        }
    }

    private void afterStart(boolean wait) {
        this.output = new Output();
        if (!wait) {
            new Thread(() -> this.update()).start();
        } else {
            this.update();
        }
    }

    public Output waitForOutput() {
        while (this.running.get()) {
        }
        return this.output;
    }

    private void afterEnd() {
        if (!this.running.get()) {
            return;
        }
        this.running.set(false);
    }

    public String getOutputString() {
        return this.output.getText();
    }

    public Output getOutputStream() {
        return this.output;
    }

    private String[] getCommandArray(String rPath) {
        int i;
        String[] c = new String[]{rPath, "--no-save", "--no-restore", "--quiet", "--file=" + this.scriptFile.getAbsolutePath(), "--args"};
        String[] cmds = new String[c.length + this.userArgs.length];
        for (i = 0; i < c.length; ++i) {
            cmds[i] = c[i];
        }
        for (i = 0; i < this.userArgs.length; ++i) {
            cmds[i + c.length] = this.userArgs[i];
        }
        return cmds;
    }

    public void defineCommand(Interpreter interpreter) {
        boolean needsEnv = false;
        String rPath = interpreter.exe;
        if (new File(rPath).exists() && SystemUtils.IS_OS_LINUX) {
            needsEnv = true;
        }
        this.commandArray = this.getCommandArray(rPath);
        if (needsEnv) {
            int i;
            String[] envVars = interpreter.getLinuxEnvVars();
            String[] commandArray2 = new String[this.commandArray.length + 1 + envVars.length];
            commandArray2[0] = "env";
            for (i = 0; i < envVars.length; ++i) {
                commandArray2[i + 1] = envVars[i];
            }
            for (i = 0; i < this.commandArray.length; ++i) {
                commandArray2[i + 1 + envVars.length] = this.commandArray[i];
            }
            this.commandArray = commandArray2;
        }
        Log.logger.fine(Script.commandArrayToCommandString(this.commandArray));
    }

    public static String commandArrayToCommandString(String[] commandArray) {
        String commandString = "";
        for (int i = 0; i < commandArray.length; ++i) {
            commandString = commandString + commandArray[i];
            if (i == commandArray.length - 1) continue;
            commandString = commandString + " ";
        }
        return commandString;
    }

    public static ProcessBuilder makeProcessBuilderWindows(String[] commandArray) {
        return new ProcessBuilder(commandArray);
    }

    public static ProcessBuilder makeProcessBuilderUnix(String[] commandArray, File dir) {
        File executeScript = new File(dir.getAbsolutePath() + File.separator + "run.sh");
        try {
            if (executeScript.exists()) {
                executeScript.delete();
            }
            executeScript.createNewFile();
            PrintWriter out = new PrintWriter(executeScript);
            out.println(Script.commandArrayToCommandString(commandArray));
            out.close();
        }
        catch (IOException ex) {
            Log.logger.severe("Error, could not create " + executeScript.getAbsolutePath());
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
        TreeSet<PosixFilePermission> permsSet = new TreeSet<PosixFilePermission>();
        permsSet.add(PosixFilePermission.OWNER_EXECUTE);
        permsSet.add(PosixFilePermission.OWNER_READ);
        try {
            Files.setPosixFilePermissions(executeScript.toPath(), permsSet);
        }
        catch (UnsupportedOperationException ex) {
            Log.logger.severe("Error, could not grant permissions to " + executeScript.getParentFile().getName() + " because the file does not support PosixFileAttributeView");
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
        catch (ClassCastException ex) {
            Log.logger.severe("Error, could not grant permissions to " + executeScript.getParentFile().getName() + " because some of the permissions granted are invalid.");
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
        catch (SecurityException ex) {
            Log.logger.severe("Error, could not grant permissions to " + executeScript.getParentFile().getName() + " because of an SecurityException.");
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
        catch (IOException ex) {
            Log.logger.severe("Error, could not grant permissions to " + executeScript.getParentFile().getName() + " because of an I/O Exception.");
            Log.logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
        String[] bashCmdArray = new String[]{"/bin/bash", executeScript.getAbsolutePath()};
        return new ProcessBuilder(bashCmdArray);
    }

    public static ProcessBuilder makeProcessBuilder(String[] commandArray, File dir) {
        ProcessBuilder processBuilder = null;
        processBuilder = SystemUtils.IS_OS_WINDOWS ? Script.makeProcessBuilderWindows(commandArray) : Script.makeProcessBuilderUnix(commandArray, dir);
        processBuilder.redirectErrorStream(true);
        return processBuilder;
    }

    public void kill() {
        if (this.process != null && this.process.isAlive() && this.running.get()) {
            this.process.destroy();
            if (this.process.isAlive()) {
                this.process.destroyForcibly();
            }
        }
    }
}

